/***************************************************************************
 *
 * Copyright (c) 2013 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include <linux/input.h>
#include <string>

#include "CalibrationHelpers.h"

using namespace std;

uint LayerManagerCalibration::parseKeyCode(const string& s, bool& valid)
{
    valid = true;

    if (!s.compare("KEY_RESERVED")) { return KEY_RESERVED; }
    if (!s.compare("KEY_ESC")) { return KEY_ESC; }
    if (!s.compare("KEY_1")) { return KEY_1; }
    if (!s.compare("KEY_2")) { return KEY_2; }
    if (!s.compare("KEY_3")) { return KEY_3; }
    if (!s.compare("KEY_4")) { return KEY_4; }
    if (!s.compare("KEY_5")) { return KEY_5; }
    if (!s.compare("KEY_6")) { return KEY_6; }
    if (!s.compare("KEY_7")) { return KEY_7; }
    if (!s.compare("KEY_8")) { return KEY_8; }
    if (!s.compare("KEY_9")) { return KEY_9; }
    if (!s.compare("KEY_0")) { return KEY_0; }
    if (!s.compare("KEY_MINUS")) { return KEY_MINUS; }
    if (!s.compare("KEY_EQUAL")) { return KEY_EQUAL; }
    if (!s.compare("KEY_BACKSPACE")) { return KEY_BACKSPACE; }
    if (!s.compare("KEY_TAB")) { return KEY_TAB; }
    if (!s.compare("KEY_Q")) { return KEY_Q; }
    if (!s.compare("KEY_W")) { return KEY_W; }
    if (!s.compare("KEY_E")) { return KEY_E; }
    if (!s.compare("KEY_R")) { return KEY_R; }
    if (!s.compare("KEY_T")) { return KEY_T; }
    if (!s.compare("KEY_Y")) { return KEY_Y; }
    if (!s.compare("KEY_U")) { return KEY_U; }
    if (!s.compare("KEY_I")) { return KEY_I; }
    if (!s.compare("KEY_O")) { return KEY_O; }
    if (!s.compare("KEY_P")) { return KEY_P; }
    if (!s.compare("KEY_LEFTBRACE")) { return KEY_LEFTBRACE; }
    if (!s.compare("KEY_RIGHTBRACE")) { return KEY_RIGHTBRACE; }
    if (!s.compare("KEY_ENTER")) { return KEY_ENTER; }
    if (!s.compare("KEY_LEFTCTRL")) { return KEY_LEFTCTRL; }
    if (!s.compare("KEY_A")) { return KEY_A; }
    if (!s.compare("KEY_S")) { return KEY_S; }
    if (!s.compare("KEY_D")) { return KEY_D; }
    if (!s.compare("KEY_F")) { return KEY_F; }
    if (!s.compare("KEY_G")) { return KEY_G; }
    if (!s.compare("KEY_H")) { return KEY_H; }
    if (!s.compare("KEY_J")) { return KEY_J; }
    if (!s.compare("KEY_K")) { return KEY_K; }
    if (!s.compare("KEY_L")) { return KEY_L; }
    if (!s.compare("KEY_SEMICOLON")) { return KEY_SEMICOLON; }
    if (!s.compare("KEY_APOSTROPHE")) { return KEY_APOSTROPHE; }
    if (!s.compare("KEY_GRAVE")) { return KEY_GRAVE; }
    if (!s.compare("KEY_LEFTSHIFT")) { return KEY_LEFTSHIFT; }
    if (!s.compare("KEY_BACKSLASH")) { return KEY_BACKSLASH; }
    if (!s.compare("KEY_Z")) { return KEY_Z; }
    if (!s.compare("KEY_X")) { return KEY_X; }
    if (!s.compare("KEY_C")) { return KEY_C; }
    if (!s.compare("KEY_V")) { return KEY_V; }
    if (!s.compare("KEY_B")) { return KEY_B; }
    if (!s.compare("KEY_N")) { return KEY_N; }
    if (!s.compare("KEY_M")) { return KEY_M; }
    if (!s.compare("KEY_COMMA")) { return KEY_COMMA; }
    if (!s.compare("KEY_DOT")) { return KEY_DOT; }
    if (!s.compare("KEY_SLASH")) { return KEY_SLASH; }
    if (!s.compare("KEY_RIGHTSHIFT")) { return KEY_RIGHTSHIFT; }
    if (!s.compare("KEY_KPASTERISK")) { return KEY_KPASTERISK; }
    if (!s.compare("KEY_LEFTALT")) { return KEY_LEFTALT; }
    if (!s.compare("KEY_SPACE")) { return KEY_SPACE; }
    if (!s.compare("KEY_CAPSLOCK")) { return KEY_CAPSLOCK; }
    if (!s.compare("KEY_F1")) { return KEY_F1; }
    if (!s.compare("KEY_F2")) { return KEY_F2; }
    if (!s.compare("KEY_F3")) { return KEY_F3; }
    if (!s.compare("KEY_F4")) { return KEY_F4; }
    if (!s.compare("KEY_F5")) { return KEY_F5; }
    if (!s.compare("KEY_F6")) { return KEY_F6; }
    if (!s.compare("KEY_F7")) { return KEY_F7; }
    if (!s.compare("KEY_F8")) { return KEY_F8; }
    if (!s.compare("KEY_F9")) { return KEY_F9; }
    if (!s.compare("KEY_F10")) { return KEY_F10; }
    if (!s.compare("KEY_NUMLOCK")) { return KEY_NUMLOCK; }
    if (!s.compare("KEY_SCROLLLOCK")) { return KEY_SCROLLLOCK; }
    if (!s.compare("KEY_KP7")) { return KEY_KP7; }
    if (!s.compare("KEY_KP8")) { return KEY_KP8; }
    if (!s.compare("KEY_KP9")) { return KEY_KP9; }
    if (!s.compare("KEY_KPMINUS")) { return KEY_KPMINUS; }
    if (!s.compare("KEY_KP4")) { return KEY_KP4; }
    if (!s.compare("KEY_KP5")) { return KEY_KP5; }
    if (!s.compare("KEY_KP6")) { return KEY_KP6; }
    if (!s.compare("KEY_KPPLUS")) { return KEY_KPPLUS; }
    if (!s.compare("KEY_KP1")) { return KEY_KP1; }
    if (!s.compare("KEY_KP2")) { return KEY_KP2; }
    if (!s.compare("KEY_KP3")) { return KEY_KP3; }
    if (!s.compare("KEY_KP0")) { return KEY_KP0; }
    if (!s.compare("KEY_KPDOT")) { return KEY_KPDOT; }
    if (!s.compare("KEY_ZENKAKUHANKAKU")) { return KEY_ZENKAKUHANKAKU; }
    if (!s.compare("KEY_102ND")) { return KEY_102ND; }
    if (!s.compare("KEY_F11")) { return KEY_F11; }
    if (!s.compare("KEY_F12")) { return KEY_F12; }
    if (!s.compare("KEY_RO")) { return KEY_RO; }
    if (!s.compare("KEY_KATAKANA")) { return KEY_KATAKANA; }
    if (!s.compare("KEY_HIRAGANA")) { return KEY_HIRAGANA; }
    if (!s.compare("KEY_HENKAN")) { return KEY_HENKAN; }
    if (!s.compare("KEY_KATAKANAHIRAGANA")) { return KEY_KATAKANAHIRAGANA; }
    if (!s.compare("KEY_MUHENKAN")) { return KEY_MUHENKAN; }
    if (!s.compare("KEY_KPJPCOMMA")) { return KEY_KPJPCOMMA; }
    if (!s.compare("KEY_KPENTER")) { return KEY_KPENTER; }
    if (!s.compare("KEY_RIGHTCTRL")) { return KEY_RIGHTCTRL; }
    if (!s.compare("KEY_KPSLASH")) { return KEY_KPSLASH; }
    if (!s.compare("KEY_SYSRQ")) { return KEY_SYSRQ; }
    if (!s.compare("KEY_RIGHTALT")) { return KEY_RIGHTALT; }
    if (!s.compare("KEY_LINEFEED")) { return KEY_LINEFEED; }
    if (!s.compare("KEY_HOME")) { return KEY_HOME; }
    if (!s.compare("KEY_UP")) { return KEY_UP; }
    if (!s.compare("KEY_PAGEUP")) { return KEY_PAGEUP; }
    if (!s.compare("KEY_LEFT")) { return KEY_LEFT; }
    if (!s.compare("KEY_RIGHT")) { return KEY_RIGHT; }
    if (!s.compare("KEY_END")) { return KEY_END; }
    if (!s.compare("KEY_DOWN")) { return KEY_DOWN; }
    if (!s.compare("KEY_PAGEDOWN")) { return KEY_PAGEDOWN; }
    if (!s.compare("KEY_INSERT")) { return KEY_INSERT; }
    if (!s.compare("KEY_DELETE")) { return KEY_DELETE; }
    if (!s.compare("KEY_MACRO")) { return KEY_MACRO; }
    if (!s.compare("KEY_MUTE")) { return KEY_MUTE; }
    if (!s.compare("KEY_VOLUMEDOWN")) { return KEY_VOLUMEDOWN; }
    if (!s.compare("KEY_VOLUMEUP")) { return KEY_VOLUMEUP; }
    if (!s.compare("KEY_POWER")) { return KEY_POWER; }
    if (!s.compare("KEY_KPEQUAL")) { return KEY_KPEQUAL; }
    if (!s.compare("KEY_KPPLUSMINUS")) { return KEY_KPPLUSMINUS; }
    if (!s.compare("KEY_PAUSE")) { return KEY_PAUSE; }
    if (!s.compare("KEY_KPCOMMA")) { return KEY_KPCOMMA; }
    if (!s.compare("KEY_HANGUEL")) { return KEY_HANGUEL; }
    if (!s.compare("KEY_HANJA")) { return KEY_HANJA; }
    if (!s.compare("KEY_YEN")) { return KEY_YEN; }
    if (!s.compare("KEY_LEFTMETA")) { return KEY_LEFTMETA; }
    if (!s.compare("KEY_RIGHTMETA")) { return KEY_RIGHTMETA; }
    if (!s.compare("KEY_COMPOSE")) { return KEY_COMPOSE; }
    if (!s.compare("KEY_STOP")) { return KEY_STOP; }
    if (!s.compare("KEY_AGAIN")) { return KEY_AGAIN; }
    if (!s.compare("KEY_PROPS")) { return KEY_PROPS; }
    if (!s.compare("KEY_UNDO")) { return KEY_UNDO; }
    if (!s.compare("KEY_FRONT")) { return KEY_FRONT; }
    if (!s.compare("KEY_COPY")) { return KEY_COPY; }
    if (!s.compare("KEY_OPEN")) { return KEY_OPEN; }
    if (!s.compare("KEY_PASTE")) { return KEY_PASTE; }
    if (!s.compare("KEY_FIND")) { return KEY_FIND; }
    if (!s.compare("KEY_CUT")) { return KEY_CUT; }
    if (!s.compare("KEY_HELP")) { return KEY_HELP; }
    if (!s.compare("KEY_MENU")) { return KEY_MENU; }
    if (!s.compare("KEY_CALC")) { return KEY_CALC; }
    if (!s.compare("KEY_SETUP")) { return KEY_SETUP; }
    if (!s.compare("KEY_SLEEP")) { return KEY_SLEEP; }
    if (!s.compare("KEY_WAKEUP")) { return KEY_WAKEUP; }
    if (!s.compare("KEY_FILE")) { return KEY_FILE; }
    if (!s.compare("KEY_SENDFILE")) { return KEY_SENDFILE; }
    if (!s.compare("KEY_DELETEFILE")) { return KEY_DELETEFILE; }
    if (!s.compare("KEY_XFER")) { return KEY_XFER; }
    if (!s.compare("KEY_PROG1")) { return KEY_PROG1; }
    if (!s.compare("KEY_PROG2")) { return KEY_PROG2; }
    if (!s.compare("KEY_WWW")) { return KEY_WWW; }
    if (!s.compare("KEY_MSDOS")) { return KEY_MSDOS; }
    if (!s.compare("KEY_COFFEE")) { return KEY_COFFEE; }
    if (!s.compare("KEY_DIRECTION")) { return KEY_DIRECTION; }
    if (!s.compare("KEY_CYCLEWINDOWS")) { return KEY_CYCLEWINDOWS; }
    if (!s.compare("KEY_MAIL")) { return KEY_MAIL; }
    if (!s.compare("KEY_BOOKMARKS")) { return KEY_BOOKMARKS; }
    if (!s.compare("KEY_COMPUTER")) { return KEY_COMPUTER; }
    if (!s.compare("KEY_BACK")) { return KEY_BACK; }
    if (!s.compare("KEY_FORWARD")) { return KEY_FORWARD; }
    if (!s.compare("KEY_CLOSECD")) { return KEY_CLOSECD; }
    if (!s.compare("KEY_EJECTCD")) { return KEY_EJECTCD; }
    if (!s.compare("KEY_EJECTCLOSECD")) { return KEY_EJECTCLOSECD; }
    if (!s.compare("KEY_NEXTSONG")) { return KEY_NEXTSONG; }
    if (!s.compare("KEY_PLAYPAUSE")) { return KEY_PLAYPAUSE; }
    if (!s.compare("KEY_PREVIOUSSONG")) { return KEY_PREVIOUSSONG; }
    if (!s.compare("KEY_STOPCD")) { return KEY_STOPCD; }
    if (!s.compare("KEY_RECORD")) { return KEY_RECORD; }
    if (!s.compare("KEY_REWIND")) { return KEY_REWIND; }
    if (!s.compare("KEY_PHONE")) { return KEY_PHONE; }
    if (!s.compare("KEY_ISO")) { return KEY_ISO; }
    if (!s.compare("KEY_CONFIG")) { return KEY_CONFIG; }
    if (!s.compare("KEY_HOMEPAGE")) { return KEY_HOMEPAGE; }
    if (!s.compare("KEY_REFRESH")) { return KEY_REFRESH; }
    if (!s.compare("KEY_EXIT")) { return KEY_EXIT; }
    if (!s.compare("KEY_MOVE")) { return KEY_MOVE; }
    if (!s.compare("KEY_EDIT")) { return KEY_EDIT; }
    if (!s.compare("KEY_SCROLLUP")) { return KEY_SCROLLUP; }
    if (!s.compare("KEY_SCROLLDOWN")) { return KEY_SCROLLDOWN; }
    if (!s.compare("KEY_KPLEFTPAREN")) { return KEY_KPLEFTPAREN; }

    valid = false;

    return KEY_RESERVED;
}
